Imports System.Reflection

Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem8 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem9 As System.Windows.Forms.MenuItem
  Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
  Friend WithEvents MenuItem10 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem11 As System.Windows.Forms.MenuItem
  Friend WithEvents StatusBar1 As System.Windows.Forms.StatusBar
  Friend WithEvents MenuItem12 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem13 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem14 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuHelpAbout As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem15 As System.Windows.Forms.MenuItem

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.MenuItem14 = New System.Windows.Forms.MenuItem()
    Me.MenuItem11 = New System.Windows.Forms.MenuItem()
    Me.MenuItem10 = New System.Windows.Forms.MenuItem()
    Me.MenuItem13 = New System.Windows.Forms.MenuItem()
    Me.MenuItem12 = New System.Windows.Forms.MenuItem()
    Me.MenuItem8 = New System.Windows.Forms.MenuItem()
    Me.MenuItem9 = New System.Windows.Forms.MenuItem()
    Me.StatusBar1 = New System.Windows.Forms.StatusBar()
    Me.MenuItem4 = New System.Windows.Forms.MenuItem()
    Me.MenuItem7 = New System.Windows.Forms.MenuItem()
    Me.MenuItem5 = New System.Windows.Forms.MenuItem()
    Me.MenuHelpAbout = New System.Windows.Forms.MenuItem()
    Me.MenuItem1 = New System.Windows.Forms.MenuItem()
    Me.MenuItem2 = New System.Windows.Forms.MenuItem()
    Me.MenuItem3 = New System.Windows.Forms.MenuItem()
    Me.MenuItem6 = New System.Windows.Forms.MenuItem()
    Me.TextBox1 = New System.Windows.Forms.TextBox()
    Me.MainMenu1 = New System.Windows.Forms.MainMenu()
    Me.MenuItem15 = New System.Windows.Forms.MenuItem()
    Me.SuspendLayout()
    '
    'MenuItem14
    '
    Me.MenuItem14.Index = 7
    Me.MenuItem14.Text = "My Types"
    '
    'MenuItem11
    '
    Me.MenuItem11.Index = 4
    Me.MenuItem11.Text = "GetFile"
    '
    'MenuItem10
    '
    Me.MenuItem10.Index = 3
    Me.MenuItem10.Text = "GetModule"
    '
    'MenuItem13
    '
    Me.MenuItem13.Index = 6
    Me.MenuItem13.Text = "Entry Point"
    '
    'MenuItem12
    '
    Me.MenuItem12.Index = 5
    Me.MenuItem12.Text = "Location"
    '
    'MenuItem8
    '
    Me.MenuItem8.Index = 1
    Me.MenuItem8.Text = "My CodeBase"
    '
    'MenuItem9
    '
    Me.MenuItem9.Index = 2
    Me.MenuItem9.Text = "My Manifest"
    '
    'StatusBar1
    '
    Me.StatusBar1.Location = New System.Drawing.Point(0, 324)
    Me.StatusBar1.Name = "StatusBar1"
    Me.StatusBar1.Size = New System.Drawing.Size(448, 20)
    Me.StatusBar1.TabIndex = 1
    Me.StatusBar1.Text = "StatusBar1"
    '
    'MenuItem4
    '
    Me.MenuItem4.Index = 0
    Me.MenuItem4.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem7, Me.MenuItem8, Me.MenuItem9, Me.MenuItem10, Me.MenuItem11, Me.MenuItem12, Me.MenuItem13, Me.MenuItem14, Me.MenuItem15})
    Me.MenuItem4.Text = "&Assembly"
    '
    'MenuItem7
    '
    Me.MenuItem7.Index = 0
    Me.MenuItem7.Text = "My Assembly"
    '
    'MenuItem5
    '
    Me.MenuItem5.Index = 2
    Me.MenuItem5.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuHelpAbout})
    Me.MenuItem5.Text = "&Help"
    '
    'MenuHelpAbout
    '
    Me.MenuHelpAbout.Index = 0
    Me.MenuHelpAbout.Text = "&About"
    '
    'MenuItem1
    '
    Me.MenuItem1.Index = 0
    Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem2})
    Me.MenuItem1.Text = "&File"
    '
    'MenuItem2
    '
    Me.MenuItem2.Index = 0
    Me.MenuItem2.Text = "E&xit"
    '
    'MenuItem3
    '
    Me.MenuItem3.Index = 1
    Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem4, Me.MenuItem6})
    Me.MenuItem3.Text = "&Demo"
    '
    'MenuItem6
    '
    Me.MenuItem6.Index = 1
    Me.MenuItem6.Text = "Dynamic Reflection Event"
    '
    'TextBox1
    '
    Me.TextBox1.Dock = System.Windows.Forms.DockStyle.Fill
    Me.TextBox1.Font = New System.Drawing.Font("Courier New", 7.8!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
    Me.TextBox1.Multiline = True
    Me.TextBox1.Name = "TextBox1"
    Me.TextBox1.ScrollBars = System.Windows.Forms.ScrollBars.Vertical
    Me.TextBox1.Size = New System.Drawing.Size(448, 344)
    Me.TextBox1.TabIndex = 0
    Me.TextBox1.Text = "TextBox1"
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem3, Me.MenuItem5})
    '
    'MenuItem15
    '
    Me.MenuItem15.Index = 8
    Me.MenuItem15.Text = "Security Test"
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
    Me.ClientSize = New System.Drawing.Size(448, 344)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.StatusBar1, Me.TextBox1})
    Me.Menu = Me.MainMenu1
    Me.Name = "Form1"
    Me.Text = "Reflection Demo"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Function GetAssembly() As Reflection.Assembly
    'Return Reflection.Assembly.GetAssembly(Me.GetType())
    Return Reflection.Assembly.GetCallingAssembly
  End Function

  Private Sub MenuItem7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem7.Click
    TextBox1.Text = GetAssembly.FullName
  End Sub

  Private Sub MenuItem8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem8.Click
    TextBox1.Text = GetAssembly.CodeBase
  End Sub

  Private Sub MenuItem9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem9.Click
    TextBox1.Text = GetAssembly.GetManifestResourceInfo( _
      "ReflectionDemo.exe.licenses").FileName
  End Sub

  Private Sub InsertText(ByVal Text As String)
    TextBox1.Text &= Text & vbCrLf
  End Sub

  Private Sub InsertModuleElements(ByVal AType As Type)
#If False Then
    Dim Enumerator As IEnumerator = _
        AType.GetMethods.GetEnumerator

    InsertText("Metody:")
    While (Enumerator.MoveNext)
      InsertText(CType(Enumerator.Current, MethodInfo).Name)
    End While

    InsertText("Pola:")
    Enumerator = AType.GetFields.GetEnumerator()
    While (Enumerator.MoveNext)
      InsertText(CType(Enumerator.Current, FieldInfo).Name)
    End While
#Else ' Verbose Version

    ' List All Methods
    Dim MethodInfos() As MethodInfo
    MethodInfos = AType.GetMethods
    Dim Enumerator As IEnumerator
    Enumerator = MethodInfos.GetEnumerator()
    TextBox1.Text &= "Metody:" & vbCrLf
    Dim AMethodInfo As MethodInfo
    While (Enumerator.MoveNext)
      AMethodInfo = CType(Enumerator.Current, MethodInfo)
      TextBox1.Text &= AMethodInfo.Name & vbCrLf
    End While

    ' List All Fields
    Dim FieldInfos() As FieldInfo
    FieldInfos = AType.GetFields
    ' Reuse earlier enumerator

    Enumerator = FieldInfos.GetEnumerator()
    TextBox1.Text &= "Pola:" & vbCrLf
    Dim AFieldInfo As FieldInfo
    While (Enumerator.MoveNext)
      AFieldInfo = CType(Enumerator.Current, FieldInfo)
      TextBox1.Text &= AFieldInfo.Name & vbCrLf
    End While
#End If

  End Sub

  Private Sub WalkModule()
    InsertText(GetAssembly.GetModules()(0).Name)
    InsertText(GetAssembly.GetTypes()(0).Name)
    InsertModuleElements(GetAssembly.GetTypes()(0))
  End Sub

  Private Sub MenuItem10_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItem10.Click
    WalkModule()
  End Sub

  Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
    TextBox1.Clear()
  End Sub

  Private Contents As String

  Private Sub WriteFileAsHex(ByVal state As Object)

    Dim Stream As IO.FileStream = _
      GetAssembly.GetFiles()(0)

    Dim B(Stream.Length) As Byte
    Stream.Read(B, 0, Stream.Length)

    Dim I As Integer

    SyncLock GetType(Form1)
      For I = 0 To B.Length() - 1
        If (I Mod 8 = 0 And I > 0) Then Contents &= " "
        If (I Mod 16 = 0 And I > 0) Then Contents &= vbCrLf
        Contents &= Hex(B(I)).PadLeft(2, "0")

        ' Usu poniszy wiersz jeli chcesz wydrukowa zawarto caego pliku
        If (I > 50000) Then Exit For
      Next
    End SyncLock

    Invoke(CType(AddressOf UpdateText, MethodInvoker))

  End Sub

  Private Sub UpdateText()
    TextBox1.Text = Contents
    StatusBar1.Text = "Loaded"
  End Sub

  Private Sub MenuItem11_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItem11.Click

    StatusBar1.Text = "Loading File..."
    TextBox1.Clear()

    Threading.ThreadPool.QueueUserWorkItem( _
          AddressOf WriteFileAsHex)
  End Sub

  Private Sub MenuItem12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem12.Click
    TextBox1.Clear()
    InsertText(GetAssembly.Location)
  End Sub

  Private Sub MenuItem13_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem13.Click
    TextBox1.Clear()
    InsertText(GetAssembly.EntryPoint.Name)
  End Sub

  Private Sub MenuItem14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem14.Click
    TextBox1.Clear()

    Dim Types() As System.Type = GetAssembly.GetTypes
    Dim I As Integer
    For I = 0 To Types.Length - 1
      TextBox1.Text &= Types(I).Name & vbCrLf
    Next
  End Sub

  Private ReadOnly Property Target() As String
    Get
#If Debug Then
      Return _
        "C:\Books\Sams\VISUAL BASIC .NET UNLEASHED\Source" & _
        "\Chapter 6\ReflectionEventDemo\bin\ReflectionEventDemo.exe"
#Else
    Return "C:\temp\ReflectionEventDemo.Exe"
#End If
    End Get
  End Property

  Private Sub AssignEvent()

    Dim App As [Assembly] = [Assembly].LoadFrom(Target)
    Dim AType As Type = App.GetTypes()(0)

    Dim AForm As Form = App.CreateInstance(AType.FullName)
    AForm.Show()

    Dim Events() As EventInfo = AType.GetEvents
    Dim D As EventHandler = AddressOf Handler

    Dim I As Integer
    For I = 0 To Events.Length - 1
      If (Events(I).Name = "Click") Then
        Events(I).AddEventHandler(AForm, D)
        Exit For
      End If
    Next

  End Sub

  Private Sub Handler(ByVal sender As System.Object, _
    ByVal e As System.EventArgs)
    MsgBox("Called from " & Application.ProductName)
  End Sub

  Private Sub MenuHelpAbout_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuHelpAbout.Click

    Const Message = "Sams VB.NET Unleashed" & vbCrLf & _
                    "Written by Paul Kimmel"
    MsgBox(Message, MsgBoxStyle.Information)
  End Sub

  Private Sub MenuItem6_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItem6.Click

    AssignEvent()

  End Sub

  Private Sub MenuItem15_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MenuItem15.Click

    Dim App As [Assembly] = [Assembly].LoadFrom(Target)
    Dim AType As Type = App.GetType("ReflectionEventDemo.Form1")
    Dim AForm As Form = App.CreateInstance(AType.FullName)

    Try
      AType.GetMethod( _
        "SecurityTest", BindingFlags.NonPublic Or BindingFlags.Instance). _
        Invoke(AForm, New Object() {})

    Catch x As Exception
      MsgBox("Exception: " & x.Message)
    End Try

  End Sub
End Class
